/*
*	Script for show and edit indexes and subindexes, which included in eds file.
*   Usage: <div index="2081:1" class="tag"></div>
* 	Nedeed scripts:
*		<script src="external/jquery/jquery.js"></script>
		<script src="external/validation/jquery.validate.js"></script>
		<script src="get_set_value_tool.js"></script>
		<script src="eds_json.js.gz" charset="utf-8"></script>
*/

(function(exports) {
	let item_data = []

	exports.parse_page = function()
	{
		const eds_script = utils.load_script('eds.js')
		Promise.all([
			eds_script
		])
		.then(() => eds.get_eds_object())
		.then(eds_object => {
			let start = new Date()

			//console.log(eds_object["index_list"])
			$(".tag").each(function(tag_index, tag_item) {
				//console.log(`tag_index:${$(tag_item).attr('index')}`)
				index_arr = $(tag_item).attr('index').split(':')
				if (index_arr[0] != "" && index_arr[1] != "")
				{
					if ((eds_object[index_arr[0]] != undefined) && (eds_object[index_arr[0]].subs != undefined))
					{
						//console.log(eds_object[index_arr[0]])
						//console.log(eds_object['index_list'][index_arr[0]][$(tag_item).attr('index')])
						item_data[tag_index] = eds_object[index_arr[0]].subs[index_arr[1]]
					}
					else
					{
						console.log(`Index: 0x${index_arr[0]}_${index_arr[1]} is absent in eds file`)
					}
				}
			})

			var end  = new Date();
			var time = end.getTime() - start.getTime()
			console.log('Timer finished in', time, 'ms')

			get_set_value.set_request_data(item_data);
			get_set_value.send_query();
		
			$(".tag").each(function(tag_index, tag_item) {
				var class_type = ""
				if ($(tag_item).hasClass("ro"))
				{
					class_type = "ro"
				}
				else if ($(tag_item).hasClass("boolean_input"))
				{
					class_type = "boolean_input"
				}
				else if ($(tag_item).hasClass("boolean_output"))
				{
					class_type = "boolean_output"
				}
				else if ($(tag_item).hasClass("boolean_alarm"))
				{
					class_type = "boolean_alarm"
				}

				//console.log(`tag_index2:${tag_index}`)
				var cell = get_set_value.get_cell(tag_index, class_type)
				$(tag_item).append(cell)
			});

			l100n.localize_all_pages()
		})
	}
	
	$(document).on('value_loaded', 'div[tb_index="2001_12"]', function( e )
	{
		if ($(this).hasClass('no_error'))
		{
			$(this).parent().parent().parent().parent().hide() 
		}
		else
		{
			$(this).parent().parent().parent().parent().show()
		}
	})

	$(document).on('value_loaded', 'div[tb_index="2001_13"]', function( e )
	{   
		if ($(this).hasClass('no_error'))
		{
			$(this).parent().parent().parent().parent().hide()
		}
		else
		{
			$(this).parent().parent().parent().parent().show()
		}
	})

	
	$(document).on("get_value_complite", function(event) 
	{
		$('.scaled').each(function( index ) {
			let scaling_index = $(this).attr('scaling_index')
			let scaling_sub = $(this).attr('scaling_sub')
			let offset_index = $(this).attr('offset_index')
			let offset_sub = $(this).attr('offset_sub')
		
			let scaling_input = $(`input[tb_index="${scaling_index}_${scaling_sub}"]`)
			let offset_input = $(`input[tb_index="${offset_index}_${offset_sub}"]`)

			let scaled = false
			if (parseFloat(scaling_input.val()) != 1)
			{
				scaled = true
			}
			if (parseFloat(offset_input.val()) != 0)
			{
				scaled = true
			}

			if (scaled)
			{
				$(this).addClass("on")
			}
			else
			{
				$(this).removeClass("on")
			}
		})
	})
})(this.user = {})